/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.graphics.RE.software.ColorDepth;
import jpcsp.graphics.RE.software.IRendererWriter;
import jpcsp.graphics.RE.software.ImageWriter;
import jpcsp.memory.IMemoryReaderWriter;

public class RendererWriter {
    public static IRendererWriter getRendererWriter(int fbAddress, int fbBufferWidth, int fbPixelFormat, int depthAddress, int depthBufferWidth, int depthPixelFormat, boolean needDepthRead, boolean needDepthWrite) {
        if (RuntimeContext.hasMemoryInt()) {
            return RendererWriter.getFastMemoryRendererWriter(fbAddress, fbBufferWidth, fbPixelFormat, depthAddress, depthBufferWidth, depthPixelFormat, needDepthRead, needDepthWrite);
        }
        return RendererWriter.getRendererWriterGeneric(fbAddress, fbBufferWidth, fbPixelFormat, depthAddress, depthBufferWidth, depthPixelFormat, needDepthRead, needDepthWrite);
    }

    private static IRendererWriter getFastMemoryRendererWriter(int fbAddress, int fbBufferWidth, int fbPixelFormat, int depthAddress, int depthBufferWidth, int depthPixelFormat, boolean needDepthRead, boolean needDepthWrite) {
        int[] memInt = RuntimeContext.getMemoryInt();
        if (depthPixelFormat == 6) {
            switch (fbPixelFormat) {
                case 3: {
                    if (needDepthRead) {
                        if (needDepthWrite) {
                            return new RendererWriterInt32(memInt, fbAddress, depthAddress);
                        }
                        return new RendererWriterNoDepthWriteInt32(memInt, fbAddress, depthAddress);
                    }
                    if (needDepthWrite) {
                        return new RendererWriterNoDepthReadInt32(memInt, fbAddress, depthAddress);
                    }
                    return new RendererWriterNoDepthReadWriteInt32(memInt, fbAddress);
                }
            }
        }
        return RendererWriter.getRendererWriterGeneric(fbAddress, fbBufferWidth, fbPixelFormat, depthAddress, depthBufferWidth, depthPixelFormat, needDepthRead, needDepthWrite);
    }

    private static IRendererWriter getRendererWriterGeneric(int fbAddress, int fbBufferWidth, int fbPixelFormat, int depthAddress, int depthBufferWidth, int depthPixelFormat, boolean needDepthRead, boolean needDepthWrite) {
        if (!needDepthRead && !needDepthWrite) {
            return new RendererWriterGenericNoDepth(fbAddress, fbBufferWidth, fbPixelFormat);
        }
        return new RendererWriterGeneric(fbAddress, fbBufferWidth, fbPixelFormat, depthAddress, depthBufferWidth, depthPixelFormat);
    }

    private static final class RendererWriterNoDepthReadWriteInt32
    implements IRendererWriter {
        private int fbIndex;
        private final int[] memInt;

        public RendererWriterNoDepthReadWriteInt32(int[] memInt, int fbAddress) {
            this.memInt = memInt;
            this.fbIndex = (fbAddress & 0x1FFFFFFF) >> 2;
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.memInt[this.fbIndex];
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.memInt[this.fbIndex] = colorDepth.color;
            ++this.fbIndex;
        }

        @Override
        public void writeNextColor(int color) {
            this.memInt[this.fbIndex] = color;
            ++this.fbIndex;
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbIndex += fbCount;
        }

        @Override
        public void flush() {
        }
    }

    private static final class RendererWriterNoDepthWriteInt32
    implements IRendererWriter {
        private int fbIndex;
        private int depthIndex;
        private int depthOffset;
        private final int[] memInt;

        public RendererWriterNoDepthWriteInt32(int[] memInt, int fbAddress, int depthAddress) {
            this.memInt = memInt;
            this.fbIndex = (fbAddress & 0x1FFFFFFF) >> 2;
            this.depthIndex = (depthAddress & 0x1FFFFFFF) >> 2;
            this.depthOffset = depthAddress >> 1 & 1;
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.memInt[this.fbIndex];
            colorDepth.depth = this.depthOffset == 0 ? this.memInt[this.depthIndex] & 0xFFFF : this.memInt[this.depthIndex] >>> 16;
        }

        private void next() {
            ++this.fbIndex;
            if (this.depthOffset == 0) {
                this.depthOffset = 1;
            } else {
                ++this.depthIndex;
                this.depthOffset = 0;
            }
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.memInt[this.fbIndex] = colorDepth.color;
            this.next();
        }

        @Override
        public void writeNextColor(int color) {
            this.memInt[this.fbIndex] = color;
            this.next();
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbIndex += fbCount;
            this.depthOffset += depthCount;
            this.depthIndex += this.depthOffset >> 1;
            this.depthOffset &= 1;
        }

        @Override
        public void flush() {
        }
    }

    private static final class RendererWriterNoDepthReadInt32
    implements IRendererWriter {
        private int fbIndex;
        private int depthIndex;
        private int depthOffset;
        private final int[] memInt;

        public RendererWriterNoDepthReadInt32(int[] memInt, int fbAddress, int depthAddress) {
            this.memInt = memInt;
            this.fbIndex = (fbAddress & 0x1FFFFFFF) >> 2;
            this.depthIndex = (depthAddress & 0x1FFFFFFF) >> 2;
            this.depthOffset = depthAddress >> 1 & 1;
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.memInt[this.fbIndex];
        }

        private void next() {
            ++this.fbIndex;
            if (this.depthOffset == 0) {
                this.depthOffset = 1;
            } else {
                ++this.depthIndex;
                this.depthOffset = 0;
            }
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.memInt[this.fbIndex] = colorDepth.color;
            this.memInt[this.depthIndex] = this.depthOffset == 0 ? this.memInt[this.depthIndex] & 0xFFFF0000 | colorDepth.depth & 0xFFFF : this.memInt[this.depthIndex] & 0xFFFF | colorDepth.depth << 16;
            this.next();
        }

        @Override
        public void writeNextColor(int color) {
            this.memInt[this.fbIndex] = color;
            this.next();
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbIndex += fbCount;
            this.depthOffset += depthCount;
            this.depthIndex += this.depthOffset >> 1;
            this.depthOffset &= 1;
        }

        @Override
        public void flush() {
        }
    }

    private static final class RendererWriterInt32
    implements IRendererWriter {
        private int fbIndex;
        private int depthIndex;
        private int depthOffset;
        private final int[] memInt;

        public RendererWriterInt32(int[] memInt, int fbAddress, int depthAddress) {
            this.memInt = memInt;
            this.fbIndex = (fbAddress & 0x1FFFFFFF) >> 2;
            this.depthIndex = (depthAddress & 0x1FFFFFFF) >> 2;
            this.depthOffset = depthAddress >> 1 & 1;
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.memInt[this.fbIndex];
            colorDepth.depth = this.depthOffset == 0 ? this.memInt[this.depthIndex] & 0xFFFF : this.memInt[this.depthIndex] >>> 16;
        }

        private void next() {
            ++this.fbIndex;
            if (this.depthOffset == 0) {
                this.depthOffset = 1;
            } else {
                ++this.depthIndex;
                this.depthOffset = 0;
            }
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.memInt[this.fbIndex] = colorDepth.color;
            this.memInt[this.depthIndex] = this.depthOffset == 0 ? this.memInt[this.depthIndex] & 0xFFFF0000 | colorDepth.depth & 0xFFFF : this.memInt[this.depthIndex] & 0xFFFF | colorDepth.depth << 16;
            this.next();
        }

        @Override
        public void writeNextColor(int color) {
            this.memInt[this.fbIndex] = color;
            this.next();
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbIndex += fbCount;
            this.depthOffset += depthCount;
            this.depthIndex += this.depthOffset >> 1;
            this.depthOffset &= 1;
        }

        @Override
        public void flush() {
        }
    }

    private static final class RendererWriterGenericNoDepth
    implements IRendererWriter {
        private final IMemoryReaderWriter fbWriter;

        public RendererWriterGenericNoDepth(int fbAddress, int fbBufferWidth, int fbPixelFormat) {
            this.fbWriter = ImageWriter.getImageWriter(fbAddress, fbBufferWidth, fbBufferWidth, fbPixelFormat);
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.fbWriter.readCurrent();
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.fbWriter.writeNext(colorDepth.color);
        }

        @Override
        public void writeNextColor(int color) {
            this.fbWriter.writeNext(color);
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbWriter.skip(fbCount);
        }

        @Override
        public void flush() {
            this.fbWriter.flush();
        }
    }

    private static final class RendererWriterGeneric
    implements IRendererWriter {
        private final IMemoryReaderWriter fbWriter;
        private final IMemoryReaderWriter depthWriter;

        public RendererWriterGeneric(int fbAddress, int fbBufferWidth, int fbPixelFormat, int depthAddress, int depthBufferWidth, int depthPixelFormat) {
            this.fbWriter = ImageWriter.getImageWriter(fbAddress, fbBufferWidth, fbBufferWidth, fbPixelFormat);
            this.depthWriter = ImageWriter.getImageWriter(depthAddress, depthBufferWidth, depthBufferWidth, depthPixelFormat);
        }

        @Override
        public void readCurrent(ColorDepth colorDepth) {
            colorDepth.color = this.fbWriter.readCurrent();
            colorDepth.depth = this.depthWriter.readCurrent();
        }

        @Override
        public void writeNext(ColorDepth colorDepth) {
            this.fbWriter.writeNext(colorDepth.color);
            this.depthWriter.writeNext(colorDepth.depth);
        }

        @Override
        public void writeNextColor(int color) {
            this.fbWriter.writeNext(color);
            this.depthWriter.skip(1);
        }

        @Override
        public void skip(int fbCount, int depthCount) {
            this.fbWriter.skip(fbCount);
            this.depthWriter.skip(depthCount);
        }

        @Override
        public void flush() {
            this.fbWriter.flush();
            this.depthWriter.flush();
        }
    }
}

